-- The duration of the splash scenes.
SPLASH_FADE_TIME = 1000
SPLASH_DISPLAY_TIME = 2000

language = "en"
languageNameFromLCID =
{
	es = "es.lproj",
	en = "en.lproj",
	nl = "nl.lproj",
	it = "it.lproj",
	fr = "fr.lproj",
	ru = "ru.lproj",
	de = "de.lproj",
	pt = "pt.lproj",
	sv = "sv.lproj",
	pl = "pl.lproj",
	-- Asian languages
	id = "id.lproj",
	zh_hans = "zh-Hans.lproj",
	zh_hant = "zh-Hant.lproj",
	ja = "ja.lproj",
	ko = "ko.lproj",
	tl = "tl.lproj",
	th = "th.lproj",
	vi = "vi.lproj",
}

steamLanguageMap =
{
    spanish = "es",
	english = "en",
    dutch = "nl",
	italian = "it",
	french = "fr",
    russian = "ru",
    german = "de",
    portuguese = "pt",
	brazilian = "pt",
	swedish = "sv",
    polish = "pl",
    indonesian = "id",
    schinese = "zh_hans",
    tchinese = "zh_hant",
    japanese = "ja",
    koreana = "ko",
    thai = "th",
	vietnamese = "vi",
}

-- See the following page for the identifiers of languages
--https://support.microsoft.com/es-es/help/193080/how-to-use-the-getuserdefaultlcid-windows-api-function-to-determine-op
-- The different language variants have the id + 1024
gameRoomLanguageMap =
{
	["1034"] = "es",
	["1033"] = "en",
	["1043"] = "nl",
	["1040"] = "it",
	["1036"] = "fr",
	["1050"] = "ru",
	["1031"] = "de",
	["1046"] = "pt",
	["1053"] = "sv",
	["1045"] = "pl",
	["1058"] = "id",
	["1028"] = "zh_hans",
	["1041"] = "ja",
	["1042"] = "ko",
	["1054"] = "th",
	["1066"] = "vi",
}

-- Copyright overwrite text for the game
--TEXT_COPYRIGHT =  "© Copyright 2015 GameHouse, a division of RealNetworks, Inc., all Rights Reserved.  Big Fish and the Big Fish logo are trademarks of Big Fish Games, used with permission."

-- GAME_TITLE can be set to override the game's title bar from text.lua (be careful, this one is not localized)
--GAME_TITLE = ""

-- This text is added to the game's name in the title bar, with a dash in between.
-- BUILD_IDENTIFIER = "Collector's Edition"

-- This number can (unsecurely) disable some earlier episodes (for BetaBoard testing)
firstAvailableEpisodeInThisBuild = 1

-- This string id is passed in the URL requests, to redirect the correct store when
-- Facebook users cick on a shared link from the game. PS: The game first checks
-- the registry for things like "z_zlm_d2c", then it falls back to one of these ids.
--onlinePartnerName = "store"
onlinePartnerName = "gamehouse"
--onlinePartnerName = "zylom"
--onlinePartnerName = "atrativa"
--onlinePartnerName = "bigfish"
--onlinePartnerName = "apple"
--onlinePartnerName = "amazon"

-- Setting this to 'false' removes facebook post links and like buttons.
doFacebook = false

-- Setting this to 'false' removes the "More Games" button.
doMoreGames = false

-- Setting this to 'false' removes Steam.
useSteam = true

-- Setting this to 'true' activates the GameRoom features.(this can only be run in the GameRoom client)
doGameRoom = false

-- Name that our webpage uses to identify this game.
onlineGameName = "d16"

-- SDK
doEnterprise = false
doPlaytest = false
PlaytestEpisode = 1

-- This link is used to redirect to a Facebook post. The parameters that are sent are:
-- <facebookPostLinkURL>?ac=&g=&game&id=&partner=&pf=&udid=&mobredir=0
-- "ac" can be one of the following:
--     like: to redirect to a 'likable' fan page.
--     up: cross-sell to another game. In this case, the 'id' parameter indicates which game.
--         In this game, 'id' can be one of the following: 'd6', 'd7', 'd8', 'd9', 'd10'.
--     cross_sell: redirect to a cross-sell page.
--     fbpost: to redirect to a facebook post. In this case, the 'id' parameter indicates the subject of the post.
--             In this game, we have the following posting subjects: 'gamefinished', 'lovemoment1' to 'lovemoment12'.
-- "g" is a number that indicates a language (conform the Zylom website language ids)
-- "game" indicates this game. Can be set through 'onlineGameName'.
-- "id" variable identifier/subject; see 'fbpost' action.
-- "partner"; see above.
-- "pf" is the platform that the game is built for.
--     It can be one of the following: "kindle", "android", "win", "winrt", "mac", "ipad" or "iphone".
-- "mobredir=0" is a mandatory Zylom website thing :-(
redirectorURL = 	"https://api.gamehouseoriginalstories.com/redirector/redirect"
imagesURL =			"http://cdn.ghstatic.com/images/corestudio/d13/"
deliciousURL =		"http://deliciousemily.com/"
deliciousNiceURL =  "www.facebook.com/DeliciousGames"
--SHARE links
share_metagame = 	"http://tinyurl.com/y7e3a8tx"
share_achievement =	"http://tinyurl.com/"
share_endlevel =	"http://tinyurl.com/yap9dsa8"
share_endchallenge ="http://tinyurl.com/y9kwj8ql"
-- A URL that redirects to a survey after the user has finished testing the game.
-- The same parameters are sent as above.
-- (Currently not supported anymore)
postGameSurveyURL = "http://bigfish.com"

-- Additional spash screens can be added by placing extra images in the "branding" folder:
-- branding2.png ... branding5.png (for high res)
-- branding2_1024.png ... branding5_1024.png (for low res)

--Choose the order of the splash screen logos.
--Each logo should have a _1024 resolution version in the branding folder.Ex: branding1.png should have also a branding1_1024.png in the branding folder.
--Add the name of the image (without the extension) in the position desired. EX:
-- splashScreenOrder =
-- {
-- 	branding1 = "GHLogo",
-- 	branding2 = "BarcelonaStudioLogo",
-- 	branding3 = "OriginalGHStory",
-- 	branding4 = "",
-- }

splashScreenOrder =
{
	--branding0 = "splash_bigfish",
	branding1 = "branding1",
	branding2 = "branding2",

}

-- A list of logos that get displayed in the "map overlay" scene.
-- partnerLogos =
-- {
-- 	{class="Sprite", x=-400.5, y=141, image="bigifsh_collector:branding"}
-- }
partnerLogos = {}

-- The path that the game uses to save data. It consisits of a literal path with substitution hooks.
-- The possible hooks are:
--     <shared app data>
--     <local app data>
--     <game name>
--     <app dir>
--     <desktop>
--     <temp>
--     <studio>          (hooks to "GameHouse" atm)
--     <language>
saveDataAppend = "<studio>/<game name>"

-- If this is set to false, the game only saves to the User's local AppData folder
-- (instead of multiple users sharing the game progress.
saveDataLocalOnly = true



-- Temp this imformation will be inside the resourcesUsage
baseURLToDownloadResources = "http://media.gamehouse.com/gameassets/develop/delicious16/v1/";
baseURLToStorageResources = "download";
